(ns deploy.serialize
  (:require [clojure.java.io :as io]
            [ring.util.response :as resp])
  (:import sun.net.www.protocol.jar.JarURLConnection
           java.net.URL
           java.io.File))

(defn blurp [f]
  (let [dest (java.io.ByteArrayOutputStream.)]
    (with-open [src (io/input-stream f)]
      (io/copy src dest)
      (.toByteArray dest))))

(defprotocol Body
  (serialize [_])
  (string-serialize [_]))

(extend-protocol Body
  String
  (serialize [s] s)
  (string-serialize [s] s)
  File
  (serialize [f] (blurp f))
  (string-serialize [f] (slurp f))
  URL
  (serialize [url]
    (-> url
        resp/resource-data
        :content
        blurp))
  (string-serialize [f]
    (slurp f))
  sun.net.www.protocol.jar.JarURLConnection$JarURLInputStream
  (serialize [i] (blurp i))
  (string-serialize [i] (slurp i)))
