(ns deploy.component.setup
  (:require [com.stuartsierra.component :as component]
            [deploy.component.shell :as shell]
            [clojure.spec :as s]
            [deploy.component.config :as config]))



(s/def ::first-deploy? boolean?)
(s/def ::submodule string?)
(s/def ::component
  (s/keys :req-un [::config/common
                   ::shell/std
                   ::shell/no-out
                   ::shell/no-abort
                   ::submodule
                   ::first-deploy?]))



(s/fdef exec
        :args (s/cat :component ::component)
        :ret nil?)

(defn exec
  "add deploy submodule to root repository on first deploy"
  [{:keys [submodule std first-deploy?]
    {:keys [destdir]} :common
    :as config}]
  (when first-deploy?
    (shell/exec std
                "git" "submodule"
                "add" "-f"
                "-b" "deploy"
                (:origin submodule)
                destdir)))

(defrecord Setup []
  component/Lifecycle
  (start [component]
    (println "[setup] start")
    (exec component)
    component)
  (stop [component]
    (println "[setup] stop")
    component))

(defn setup [& [m]]
  (map->Setup m))
