(ns deploy.component.load-handler
  (:require [com.stuartsierra.component :as component]
            [load-system.core :as load]
            [clojure.spec :as s]))

(s/def ::handler-path (s/coll-of keyword? :kind vector?))
(s/def ::remove-components (s/coll-of keyword?))
(s/def ::bindings (s/map-of simple-symbol? any?))
(s/def ::sources (s/coll-of any?))

(s/def ::component
  (s/keys :req-un [::handler-path ::remove-components ::bindings ::sources]))

(s/fdef load-handler*
        :args (s/cat :component ::component)
        :ret fn?)

(defn load-handler*
  "load system, remove unneeded components, start system, and return handler path"
  [{:keys [sources bindings remove-components handler-path]
             :as config}]
  (->
   (fn [system remove-component]
     (dissoc system remove-component))
   (reduce (load/load-system sources bindings)
           remove-components)
   (component/start-system)
   (get-in handler-path)))

(defrecord LoadHandler []
  component/Lifecycle
  (start [component]
    (println "[load handler] start")
    (assoc component
           :handler (load-handler* component)))
  (stop [component]
    (println "[load handler] stop")
    (assoc component
           :handler nil)))

(defn load-handler [& [m]]
  (map->LoadHandler m))
