(ns deploy.component.extract
  (:require [com.stuartsierra.component :as component]
            [deploy.component.shell :as shell]
            [clojure.spec :as s]
            [deploy.component.config :as config]))

(s/def ::files-to-extract (s/coll-of string?))

(s/def ::component
  (s/keys :req-un [::config/common ::shell/no-out ::shell/std ::shell/no-abort ::files-to-extract]))

(s/fdef exec
        :args (s/cat :component ::component)
        :ret nil?)

(defn exec [{:keys [files-to-extract no-out]
             {:keys [destdir]} :common
             :as component}]

  (println "\n**Extract archived files**")

  (doseq [f files-to-extract]
    (shell/exec no-out
                "tar" "xvfz"  f "-C" destdir)))

(defrecord Extract []
  component/Lifecycle
  (start [component]
    (println "[extract] start")
    (exec component)
    component)
  (stop [component]
    (println "[extract] stop")
    component))

(defn extract [& [m]]
  (map->Extract m))
