/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.oor;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.oor.healtcheck.OorHealthCheck;
import io.dropwizard.oor.tasks.BirTask;
import io.dropwizard.oor.tasks.OorTask;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OorBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(OorBundle.class);

    public abstract boolean withOor();

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        environment.healthChecks().register("oor", (HealthCheck)new OorHealthCheck(this.withOor()));
        environment.admin().addTask((Task)new OorTask());
        environment.admin().addTask((Task)new BirTask());
    }
}

