/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.checkmate.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.dropwizard.checkmate.ChecksumAlgorithm;
import io.dropwizard.checkmate.core.ChecksumInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import javax.ws.rs.container.ContainerResponseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ChecksumUtil {
    public static final String RIGHT_PADDED_ZERO = "0000000000000000";
    public static final int DEFAULT_LENGTH = 16;
    public static final int PART4_LENGTH = 4;
    public static final int OFFSET1 = 0;
    public static final int OFFSET2 = 8;
    public static final int OFFSET3 = 16;
    public static final int OFFSET4 = 24;
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    public static final String REQUEST_CHECKSUM_HEADER = "X-REQUEST-TOKEN";
    public static final String REQUEST_CHECKSUM_V2_HEADER = "X-REQUEST-CHECKSUM";
    public static final String REQUEST_CHECKSUM_SDK_HEADER = "X-REQUEST-SDK-CHECKSUM";
    public static final Logger log = LoggerFactory.getLogger((String)"Checkmate");
    public static final String REQUEST_APP_ID_HEADER = "X-APP-ID";

    public static String checksum(String path, byte[] body) throws IOException {
        Hasher hasher = Hashing.sha256().newHasher();
        hasher.putString((CharSequence)path, Charsets.UTF_8);
        if (null != body) {
            hasher.putBytes(body);
        }
        return Base64.getEncoder().encodeToString(hasher.hash().asBytes());
    }

    public static String checksum(ContainerResponseContext responseContext, ChecksumAlgorithm checksumAlgorithm) throws IOException {
        switch (checksumAlgorithm) {
            case ALGO_V1: 
            case ALGO_V2: 
            case ALGO_SDK_V1: {
                Hasher hasher = Hashing.sha256().newHasher();
                hasher.putString((CharSequence)String.format("%04d", responseContext.getStatus()), StandardCharsets.UTF_8);
                if (responseContext.hasEntity()) {
                    log.debug("Entity type: {}", (Object)responseContext.getEntityClass().getCanonicalName());
                    hasher.putBytes(ChecksumUtil.convertToBytes(responseContext.getEntity()));
                }
                return Base64.getEncoder().encodeToString(hasher.hash().asBytes());
            }
        }
        return null;
    }

    public static byte[] convertToBytes(Object object) throws IOException {
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        log.warn("Unknown Entity type {}. Body not included in checksum! ", (Object)object.getClass().getTypeName());
        return new byte[0];
    }

    public static ChecksumInfo decodeHeader(String token) {
        if (Strings.isNullOrEmpty((String)token)) {
            throw new IllegalArgumentException("Bad token");
        }
        String decodedToken = new String(Base64.getDecoder().decode(token), Charsets.UTF_8);
        log.debug("Base 64 decoded token: {}", (Object)decodedToken);
        String[] parts = decodedToken.split("###");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Bad token, could not be split: " + token);
        }
        log.debug("Decoded Token: {}", (Object)token);
        return ChecksumInfo.builder().salt(parts[0]).checksumData(parts[1]).build();
    }

    public static ChecksumInfo decodeHeaderSDK(String token) {
        if (Strings.isNullOrEmpty((String)token)) {
            throw new IllegalArgumentException("Bad token");
        }
        String decodedToken = new String(Base64.getDecoder().decode(token), DEFAULT_CHARSET);
        log.debug("Base 64 decoded token: {}", (Object)decodedToken);
        String salt = ChecksumUtil.extractSaltFromOffsets(decodedToken);
        String checksumData = ChecksumUtil.extractChecksumDataFromOffsets(decodedToken);
        if (Strings.isNullOrEmpty((String)salt) || Strings.isNullOrEmpty((String)checksumData)) {
            throw new IllegalArgumentException("Bad token, could not be decoded: " + token);
        }
        log.debug("Decoded Token: {} Salt: {} Checksum: {}", new Object[]{token, salt, checksumData});
        return ChecksumInfo.builder().salt(salt).checksumData(checksumData).build();
    }

    public static String extractChecksumDataFromOffsets(String data) {
        String dataPart1 = data.substring(0, 24);
        String dataPart2 = data.substring(28, data.length());
        data = dataPart1 + dataPart2;
        dataPart1 = data.substring(0, 16);
        dataPart2 = data.substring(20, data.length());
        data = dataPart1 + dataPart2;
        dataPart1 = data.substring(0, 8);
        dataPart2 = data.substring(12, data.length());
        data = dataPart1 + dataPart2;
        dataPart1 = data.substring(0, 0);
        dataPart2 = data.substring(4, data.length());
        data = dataPart1 + dataPart2;
        return data;
    }

    public static String extractSaltFromOffsets(String data) {
        String keyPart4 = data.substring(24, 28);
        String keyPart3 = data.substring(16, 20);
        String keyPart2 = data.substring(8, 12);
        String keyPart1 = data.substring(0, 4);
        return keyPart1 + keyPart2 + keyPart3 + keyPart4;
    }

    public static String generateKey(String sig, String salt) {
        if (sig.length() < 16) {
            sig = sig + RIGHT_PADDED_ZERO;
        }
        if (salt.length() < 16) {
            salt = salt + RIGHT_PADDED_ZERO;
        }
        sig = sig.substring(0, 16);
        salt = salt.substring(0, 16);
        byte[] sigBytes = sig.getBytes(DEFAULT_CHARSET);
        byte[] uuidBytes = salt.getBytes(DEFAULT_CHARSET);
        byte[] keyBytes = new byte[32];
        for (int i = 0; i < 16; ++i) {
            keyBytes[i * 2] = sigBytes[i];
            keyBytes[i * 2 + 1] = uuidBytes[i];
        }
        return new String(keyBytes, DEFAULT_CHARSET);
    }

    public static boolean isExpired(long requestTime, int clockSkew) {
        return Instant.now().isAfter(Instant.ofEpochMilli(requestTime).plusSeconds(clockSkew)) || Instant.now().isBefore(Instant.ofEpochMilli(requestTime).minusSeconds(clockSkew));
    }
}

