/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.checkmate.utils;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import io.dropwizard.checkmate.CheckmateBundle;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public interface AESUtil {
    public static final String ALGORITHM = "AES";

    public static String encrypt(String input, String salt) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(Arrays.copyOf(Hashing.sha1().hashString((CharSequence)salt, Charsets.UTF_8).asBytes(), 16), ALGORITHM);
        Cipher cipher = Cipher.getInstance(CheckmateBundle.getConfig() == null ? "AES/ECB/PKCS5Padding" : CheckmateBundle.getConfig().getAlgorithm());
        cipher.init(1, secretKey);
        byte[] encrypted = cipher.doFinal(input.getBytes(Charsets.UTF_8));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public static String decrypt(String input, String salt) throws Exception {
        byte[] encrypted = Base64.getDecoder().decode(input.getBytes(Charsets.UTF_8));
        SecretKeySpec secretKey = new SecretKeySpec(Arrays.copyOf(Hashing.sha1().hashString((CharSequence)salt, Charsets.UTF_8).asBytes(), 16), ALGORITHM);
        Cipher cipher = Cipher.getInstance(CheckmateBundle.getConfig() == null ? "AES/ECB/PKCS5Padding" : CheckmateBundle.getConfig().getAlgorithm());
        cipher.init(2, secretKey);
        byte[] outputBytes = cipher.doFinal(encrypted);
        return new String(outputBytes);
    }
}

