/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.checkmate.model;

import com.platform.http.HttpClientConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class CheckmateBundleConfiguration {
    private boolean requestValidation;
    private boolean responseChecksum;
    private boolean expiryCheck;
    private int clockSkew;
    private String algorithm = "AES/ECB/PKCS5Padding";
    private String salt;
    private Set<String> whiteList = new HashSet<String>();
    private List<String> headersList = new ArrayList<String>();
    @NotNull
    @Valid
    private HttpClientConfiguration appKeyService = new HttpClientConfiguration();
    private Map<String, String> pathVsMetricMap;

    public static CheckmateBundleConfigurationBuilder builder() {
        return new CheckmateBundleConfigurationBuilder();
    }

    public boolean isRequestValidation() {
        return this.requestValidation;
    }

    public boolean isResponseChecksum() {
        return this.responseChecksum;
    }

    public boolean isExpiryCheck() {
        return this.expiryCheck;
    }

    public int getClockSkew() {
        return this.clockSkew;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSalt() {
        return this.salt;
    }

    public Set<String> getWhiteList() {
        return this.whiteList;
    }

    public List<String> getHeadersList() {
        return this.headersList;
    }

    public HttpClientConfiguration getAppKeyService() {
        return this.appKeyService;
    }

    public Map<String, String> getPathVsMetricMap() {
        return this.pathVsMetricMap;
    }

    public void setRequestValidation(boolean requestValidation) {
        this.requestValidation = requestValidation;
    }

    public void setResponseChecksum(boolean responseChecksum) {
        this.responseChecksum = responseChecksum;
    }

    public void setExpiryCheck(boolean expiryCheck) {
        this.expiryCheck = expiryCheck;
    }

    public void setClockSkew(int clockSkew) {
        this.clockSkew = clockSkew;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setWhiteList(Set<String> whiteList) {
        this.whiteList = whiteList;
    }

    public void setHeadersList(List<String> headersList) {
        this.headersList = headersList;
    }

    public void setAppKeyService(HttpClientConfiguration appKeyService) {
        this.appKeyService = appKeyService;
    }

    public void setPathVsMetricMap(Map<String, String> pathVsMetricMap) {
        this.pathVsMetricMap = pathVsMetricMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckmateBundleConfiguration)) {
            return false;
        }
        CheckmateBundleConfiguration other = (CheckmateBundleConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequestValidation() != other.isRequestValidation()) {
            return false;
        }
        if (this.isResponseChecksum() != other.isResponseChecksum()) {
            return false;
        }
        if (this.isExpiryCheck() != other.isExpiryCheck()) {
            return false;
        }
        if (this.getClockSkew() != other.getClockSkew()) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        Set<String> this$whiteList = this.getWhiteList();
        Set<String> other$whiteList = other.getWhiteList();
        if (this$whiteList == null ? other$whiteList != null : !((Object)this$whiteList).equals(other$whiteList)) {
            return false;
        }
        List<String> this$headersList = this.getHeadersList();
        List<String> other$headersList = other.getHeadersList();
        if (this$headersList == null ? other$headersList != null : !((Object)this$headersList).equals(other$headersList)) {
            return false;
        }
        HttpClientConfiguration this$appKeyService = this.getAppKeyService();
        HttpClientConfiguration other$appKeyService = other.getAppKeyService();
        if (this$appKeyService == null ? other$appKeyService != null : !this$appKeyService.equals(other$appKeyService)) {
            return false;
        }
        Map<String, String> this$pathVsMetricMap = this.getPathVsMetricMap();
        Map<String, String> other$pathVsMetricMap = other.getPathVsMetricMap();
        return !(this$pathVsMetricMap == null ? other$pathVsMetricMap != null : !((Object)this$pathVsMetricMap).equals(other$pathVsMetricMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckmateBundleConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequestValidation() ? 79 : 97);
        result = result * 59 + (this.isResponseChecksum() ? 79 : 97);
        result = result * 59 + (this.isExpiryCheck() ? 79 : 97);
        result = result * 59 + this.getClockSkew();
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        Set<String> $whiteList = this.getWhiteList();
        result = result * 59 + ($whiteList == null ? 43 : ((Object)$whiteList).hashCode());
        List<String> $headersList = this.getHeadersList();
        result = result * 59 + ($headersList == null ? 43 : ((Object)$headersList).hashCode());
        HttpClientConfiguration $appKeyService = this.getAppKeyService();
        result = result * 59 + ($appKeyService == null ? 43 : $appKeyService.hashCode());
        Map<String, String> $pathVsMetricMap = this.getPathVsMetricMap();
        result = result * 59 + ($pathVsMetricMap == null ? 43 : ((Object)$pathVsMetricMap).hashCode());
        return result;
    }

    public String toString() {
        return "CheckmateBundleConfiguration(requestValidation=" + this.isRequestValidation() + ", responseChecksum=" + this.isResponseChecksum() + ", expiryCheck=" + this.isExpiryCheck() + ", clockSkew=" + this.getClockSkew() + ", algorithm=" + this.getAlgorithm() + ", salt=" + this.getSalt() + ", whiteList=" + this.getWhiteList() + ", headersList=" + this.getHeadersList() + ", appKeyService=" + this.getAppKeyService() + ", pathVsMetricMap=" + this.getPathVsMetricMap() + ")";
    }

    public CheckmateBundleConfiguration(boolean requestValidation, boolean responseChecksum, boolean expiryCheck, int clockSkew, String algorithm, String salt, Set<String> whiteList, List<String> headersList, HttpClientConfiguration appKeyService, Map<String, String> pathVsMetricMap) {
        this.requestValidation = requestValidation;
        this.responseChecksum = responseChecksum;
        this.expiryCheck = expiryCheck;
        this.clockSkew = clockSkew;
        this.algorithm = algorithm;
        this.salt = salt;
        this.whiteList = whiteList;
        this.headersList = headersList;
        this.appKeyService = appKeyService;
        this.pathVsMetricMap = pathVsMetricMap;
    }

    public CheckmateBundleConfiguration() {
    }

    public static class CheckmateBundleConfigurationBuilder {
        private boolean requestValidation;
        private boolean responseChecksum;
        private int clockSkew;
        private String algorithm;
        private String salt;
        private Set<String> whiteList;
        private List<String> headersList;
        private HttpClientConfiguration appKeyService;
        private Map<String, String> pathVsMetricMap;
        private boolean expiryCheck = true;

        CheckmateBundleConfigurationBuilder() {
        }

        public CheckmateBundleConfigurationBuilder requestValidation(boolean requestValidation) {
            this.requestValidation = requestValidation;
            return this;
        }

        public CheckmateBundleConfigurationBuilder responseChecksum(boolean responseChecksum) {
            this.responseChecksum = responseChecksum;
            return this;
        }

        public CheckmateBundleConfigurationBuilder expiryCheck(boolean expiryCheck) {
            this.expiryCheck = expiryCheck;
            return this;
        }

        public CheckmateBundleConfigurationBuilder clockSkew(int clockSkew) {
            this.clockSkew = clockSkew;
            return this;
        }

        public CheckmateBundleConfigurationBuilder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public CheckmateBundleConfigurationBuilder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public CheckmateBundleConfigurationBuilder whiteList(Set<String> whiteList) {
            this.whiteList = whiteList;
            return this;
        }

        public CheckmateBundleConfigurationBuilder headersList(List<String> headersList) {
            this.headersList = headersList;
            return this;
        }

        public CheckmateBundleConfigurationBuilder appKeyService(HttpClientConfiguration appKeyService) {
            this.appKeyService = appKeyService;
            return this;
        }

        public CheckmateBundleConfigurationBuilder pathVsMetricMap(Map<String, String> pathVsMetricMap) {
            this.pathVsMetricMap = pathVsMetricMap;
            return this;
        }

        public CheckmateBundleConfiguration build() {
            return new CheckmateBundleConfiguration(this.requestValidation, this.responseChecksum, this.expiryCheck, this.clockSkew, this.algorithm, this.salt, this.whiteList, this.headersList, this.appKeyService, this.pathVsMetricMap);
        }

        public String toString() {
            return "CheckmateBundleConfiguration.CheckmateBundleConfigurationBuilder(requestValidation=" + this.requestValidation + ", responseChecksum=" + this.responseChecksum + ", expiryCheck=" + this.expiryCheck + ", clockSkew=" + this.clockSkew + ", algorithm=" + this.algorithm + ", salt=" + this.salt + ", whiteList=" + this.whiteList + ", headersList=" + this.headersList + ", appKeyService=" + this.appKeyService + ", pathVsMetricMap=" + this.pathVsMetricMap + ")";
        }
    }
}

