/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.checkmate.filters;

import io.dropwizard.checkmate.core.ChecksumInfo;
import io.dropwizard.checkmate.model.CheckmateBundleConfiguration;
import io.dropwizard.checkmate.utils.AESUtil;
import io.dropwizard.checkmate.utils.ChecksumUtil;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
@Priority(value=3000)
public class CheckmateResponseFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(CheckmateResponseFilter.class);
    private static final String RESPONSE_CHECKSUM_HEADER = "X-RESPONSE-TOKEN";
    private CheckmateBundleConfiguration configuration;

    public CheckmateResponseFilter(CheckmateBundleConfiguration configuration) {
        this.configuration = configuration;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (!this.configuration.isResponseChecksum()) {
            return;
        }
        try {
            if (requestContext.getProperty("io.dropwizard.checkmate.filters.checksumInfo") != null) {
                ChecksumInfo checksumInfo = (ChecksumInfo)requestContext.getProperty("io.dropwizard.checkmate.filters.checksumInfo");
                String checksum = ChecksumUtil.checksum(responseContext, checksumInfo.getChecksumAlgorithm());
                String builder = String.valueOf(System.currentTimeMillis()) + "###" + checksum;
                String responseTokenV1 = AESUtil.encrypt(builder, checksumInfo.getEncryptionKey());
                log.debug("Response token: {} Salt: {}", (Object)responseTokenV1, (Object)checksumInfo.getEncryptionKey());
                responseContext.getHeaders().putSingle((Object)RESPONSE_CHECKSUM_HEADER, (Object)responseTokenV1);
            } else {
                log.warn("No checksum info passed in context .. no response checksum will be added");
            }
        }
        catch (Exception e) {
            log.error("Cannot stamp response checksum", (Throwable)e);
        }
    }

    public static CheckmateResponseFilterBuilder builder() {
        return new CheckmateResponseFilterBuilder();
    }

    public static class CheckmateResponseFilterBuilder {
        private CheckmateBundleConfiguration configuration;

        CheckmateResponseFilterBuilder() {
        }

        public CheckmateResponseFilterBuilder configuration(CheckmateBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public CheckmateResponseFilter build() {
            return new CheckmateResponseFilter(this.configuration);
        }

        public String toString() {
            return "CheckmateResponseFilter.CheckmateResponseFilterBuilder(configuration=" + this.configuration + ")";
        }
    }
}

