/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.checkmate.appkey;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.platform.http.Endpoint;
import com.platform.http.HttpClientConfiguration;
import com.platform.http.OkHttpUtils;
import com.platform.http.ServiceEndpointProvider;
import io.dropwizard.checkmate.appkey.AppKeySource;
import java.util.Optional;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAppKeySource
implements AppKeySource {
    private static final Logger log = LoggerFactory.getLogger(RemoteAppKeySource.class);
    private final OkHttpClient okHttp;
    private final ObjectMapper mapper;
    private final ServiceEndpointProvider endpointProvider;

    public RemoteAppKeySource(HttpClientConfiguration clientConfiguration, ObjectMapper mapper, ServiceEndpointProvider endpointProvider) {
        this.okHttp = OkHttpUtils.createOkHttpClient((HttpClientConfiguration)clientConfiguration);
        this.mapper = mapper;
        this.endpointProvider = endpointProvider;
    }

    @Override
    public String appKey(String appId) throws Exception {
        Preconditions.checkNotNull((Object)this.okHttp, (Object)"Please call initialize() to setup the HTTP client");
        Optional endPointOptional = this.endpointProvider.endpoint();
        if (!endPointOptional.isPresent()) {
            throw new Exception("No endpoint found to retrieve app key for: " + appId);
        }
        HttpUrl url = ((Endpoint)endPointOptional.get()).url("/v1/applications/" + appId);
        Request request = new Request.Builder().url(url).get().build();
        log.info("App key get call: GET {}", (Object)url);
        Response response = this.okHttp.newCall(request).execute();
        byte[] responseBody = OkHttpUtils.body((Response)response);
        if (!response.isSuccessful()) {
            log.error("Error in getting app key for: {} {}", (Object)appId, (Object)(null != responseBody ? new String(responseBody) : null));
            throw new Exception("Error making http call to get app key for: " + appId);
        }
        if (null == responseBody) {
            return null;
        }
        JsonNode node = this.mapper.readTree(responseBody);
        if (node.has("signature")) {
            return node.get("signature").asText();
        }
        return null;
    }
}

