/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.checkmate;

import com.codahale.metrics.MetricRegistry;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.platform.http.ServiceEndpointProvider;
import com.platform.http.ServiceEndpointProviderFactory;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.checkmate.appkey.RemoteAppKeySource;
import io.dropwizard.checkmate.filters.CheckmateRequestFilter;
import io.dropwizard.checkmate.filters.CheckmateResponseFilter;
import io.dropwizard.checkmate.model.CheckmateBundleConfiguration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CheckmateBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(CheckmateBundle.class);
    private static CheckmateBundleConfiguration config;
    private static List<String> whiteList;
    private final CuratorFramework curatorFramework;

    protected CheckmateBundle(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    public abstract CheckmateBundleConfiguration getCheckmateConfiguration(T var1);

    public void run(T configuration, Environment environment) throws Exception {
        config = this.getCheckmateConfiguration(configuration);
        ServiceEndpointProviderFactory serviceEndpointFactory = new ServiceEndpointProviderFactory(this.curatorFramework);
        MetricRegistry metrics = environment.metrics();
        ServiceEndpointProvider appKeyServiceEndpointProvider = serviceEndpointFactory.provider(config.getAppKeyService(), environment);
        final RemoteAppKeySource source = new RemoteAppKeySource(config.getAppKeyService(), environment.getObjectMapper(), appKeyServiceEndpointProvider);
        LoadingCache appSignatureCache = CacheBuilder.newBuilder().concurrencyLevel(10).maximumSize(20000L).initialCapacity(100).refreshAfterWrite(1L, TimeUnit.HOURS).expireAfterWrite(1L, TimeUnit.DAYS).removalListener(notification -> log.info("Removing app key for: {}", notification.getKey())).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                try {
                    log.info("Loading app key for: {}", (Object)key);
                    return source.appKey(key);
                }
                catch (Throwable t) {
                    log.error("Error loading app key for app " + key, t);
                    throw t;
                }
            }
        });
        environment.jersey().register((Object)new CheckmateRequestFilter(this.getCheckmateConfiguration(configuration), (LoadingCache<String, String>)appSignatureCache, metrics));
        environment.jersey().register((Object)new CheckmateResponseFilter(this.getCheckmateConfiguration(configuration)));
        config.getWhiteList().forEach(l -> whiteList.add(CheckmateBundle.generatePathExpression(l)));
        Collections.sort(whiteList, String::compareTo);
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public static CheckmateBundleConfiguration getConfig() {
        return config;
    }

    private static String generatePathExpression(String path) {
        return path.replaceAll("\\{(([^/])+\\})", "(([^/])+)");
    }

    public static List<String> getWhiteList() {
        return whiteList;
    }

    static {
        whiteList = new ArrayList<String>();
    }
}

