(ns org.domaindrivenarchitecture.pallet.crate.tomcat.app-config-test
  (:require
    [clojure.test :refer :all]
    [org.domaindrivenarchitecture.pallet.crate.tomcat.app-config :as sut]
   )
 )

(def old-server-xml-config
  "the old server xml-config"
  {:shutdown-port "8005"
   :ajp-port nil
   :http-port "8080"
   :service-name "Catalina"
   :thread-pool "tomcatThreadPool"
   :protocol "HTTP/1.1"
   :executorMaxThreads "150"
   :connectorMaxThreads "150"
   :connectionTimeout "20000"
   :executor "tomcatThreadPool"})
  
(defn old-server-xml-string-1
  []
  ["<?xml version='1.0' encoding='utf-8'?>"
  "<!--"
  " Licensed to the Apache Software Foundation (ASF) under one or more"
  "  contributor license agreements.  See the NOTICE file distributed with"
  "  this work for additional information regarding copyright ownership."
  "  The ASF licenses this file to You under the Apache License, Version 2.0"
  "  (the \"License\"); you may not use this file except in compliance with"
  "  the License.  You may obtain a copy of the License at"
  ""
  "      http://www.apache.org/licenses/LICENSE-2.0"
  ""
  "  Unless required by applicable law or agreed to in writing, software"
  "  distributed under the License is distributed on an \"AS IS\" BASIS,"
  "  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied."
  "  See the License for the specific language governing permissions and"
  "  limitations under the License."
  "-->"
  "<!-- Note:  A \"Server\" is not itself a \"Container\", so you may not"
  "     define subcomponents such as \"Valves\" at this level."
  "     Documentation at /docs/config/server.html"
  "-->"
  "<Server port=\"8005\" shutdown=\"SHUTDOWN\">"
  "  <!-- Security listener. Documentation at /docs/config/listeners.html"
  "  <Listener className=\"org.apache.catalina.security.SecurityListener\" />"
  "  -->"
  "  <!--APR library loader. Documentation at /docs/apr.html -->"
  "  <!--"
  "  <Listener className=\"org.apache.catalina.core.AprLifecycleListener\" SSLEngine=\"on\" />"
  "  -->"
  "  <!--Initialize Jasper prior to webapps are loaded. Documentation at /docs/jasper-howto.html -->"
  "  <Listener className=\"org.apache.catalina.core.JasperListener\" />"
  "  <!-- Prevent memory leaks due to use of particular java/javax APIs-->"
  "  <Listener className=\"org.apache.catalina.core.JreMemoryLeakPreventionListener\" />"
  "  <Listener className=\"org.apache.catalina.mbeans.GlobalResourcesLifecycleListener\" />"
  "  <Listener className=\"org.apache.catalina.core.ThreadLocalLeakPreventionListener\" />"
  ""
  "  <!-- Global JNDI resources"
  "       Documentation at /docs/jndi-resources-howto.html"
  "  -->"
  "  <GlobalNamingResources>"
  "    <!-- Editable user database that can also be used by"
  "         UserDatabaseRealm to authenticate users"
  "    -->"
  "    <Resource name=\"UserDatabase\" auth=\"Container\""
  "              type=\"org.apache.catalina.UserDatabase\""
  "              description=\"User database that can be updated and saved\""
  "              factory=\"org.apache.catalina.users.MemoryUserDatabaseFactory\""
  "              pathname=\"conf/tomcat-users.xml\" />"
  "  </GlobalNamingResources>"
  ""
  "  <!-- A \"Service\" is a collection of one or more \"Connectors\" that share"
  "       a single \"Container\" Note:  A \"Service\" is not itself a \"Container\","
  "       so you may not define subcomponents such as \"Valves\" at this level."
  "       Documentation at /docs/config/service.html"
  "   -->"
  "  <Service name=\"Catalina\">"
  ""
  "    <!--The connectors can use a shared executor, you can define one or more named thread pools-->"
  "    <!--"
  "    <Executor name=\"tomcatThreadPool\" namePrefix=\"catalina-exec-\""
  "        maxThreads=\"150\" minSpareThreads=\"4\"/>"
  "    -->"
  ""
  ""
  "    <!-- A \"Connector\" represents an endpoint by which requests are received"
  "         and responses are returned. Documentation at :"
  "         Java HTTP Connector: /docs/config/http.html (blocking & non-blocking)"
  "         Java AJP  Connector: /docs/config/ajp.html"
  "         APR (HTTP/AJP) Connector: /docs/apr.html"
  "         Define a non-SSL HTTP/1.1 Connector on port 8080"
  "    -->"]
  )

(defn old-server-xml-string-2
  []
  ["    <Connector port=\"8080\" protocol=\"HTTP/1.1\""
  "               connectionTimeout=\"20000\""
  "               URIEncoding=\"UTF-8\""
  "               redirectPort=\"8443\" />"
  "    <!-- A \"Connector\" using the shared thread pool-->"
  "    <!--"
  "    <Connector executor=\"tomcatThreadPool\""
  "               port=\"8080\" protocol=\"HTTP/1.1\""
  "               connectionTimeout=\"20000\""
  "               redirectPort=\"8443\" />"
  "    -->"
  "    <!-- Define a SSL HTTP/1.1 Connector on port 8443"
  "         This connector uses the JSSE configuration, when using APR, the"
  "         connector should be using the OpenSSL style configuration"
  "         described in the APR documentation -->"
  "    <!--"
  "    <Connector port=\"8443\" protocol=\"HTTP/1.1\" SSLEnabled=\"true\""
  "               maxThreads=\"150\" scheme=\"https\" secure=\"true\""
  "               clientAuth=\"false\" sslProtocol=\"TLS\" />"
  "    -->"
  ""
  "    <!-- Define an AJP 1.3 Connector on port 8009 -->"
  "    <!--"
  "    <Connector port=\"8009\" protocol=\"AJP/1.3\" redirectPort=\"8443\" />"
  "    -->"
  ""
  ""
  "    <!-- An Engine represents the entry point (within Catalina) that processes"
  "         every request.  The Engine implementation for Tomcat stand alone"
  "         analyzes the HTTP headers included with the request, and passes them"
  "         on to the appropriate Host (virtual host)."
  "         Documentation at /docs/config/engine.html -->"
  ""
  "    <!-- You should set jvmRoute to support load-balancing via AJP ie :"
  "    <Engine name=\"Catalina\" defaultHost=\"localhost\" jvmRoute=\"jvm1\">"
  "    -->"
  "    <Engine name=\"Catalina\" defaultHost=\"localhost\">"
  ""
  "      <!--For clustering, please take a look at documentation at:"
  "          /docs/cluster-howto.html  (simple how to)"
  "          /docs/config/cluster.html (reference documentation) -->"
  "      <!--"
  "      <Cluster className=\"org.apache.catalina.ha.tcp.SimpleTcpCluster\"/>"
  "      -->"
  ""
  "      <!-- Use the LockOutRealm to prevent attempts to guess user passwords"
  "           via a brute-force attack -->"
  "      <Realm className=\"org.apache.catalina.realm.LockOutRealm\">"
  "        <!-- This Realm uses the UserDatabase configured in the global JNDI"
  "             resources under the key \"UserDatabase\".  Any edits"
  "             that are performed against this UserDatabase are immediately"
  "             available for use by the Realm.  -->"
  "        <Realm className=\"org.apache.catalina.realm.UserDatabaseRealm\""
  "               resourceName=\"UserDatabase\"/>"
  "      </Realm>"
  ""
  "      <Host name=\"localhost\"  appBase=\"webapps\""
  "            unpackWARs=\"true\" autoDeploy=\"true\">"
  ""
  "        <!-- SingleSignOn valve, share authentication between web applications"
  "             Documentation at: /docs/config/valve.html -->"
  "        <!--"
  "        <Valve className=\"org.apache.catalina.authenticator.SingleSignOn\" />"
  "        -->"
  ""
  "        <!-- Access log processes all example."
  "             Documentation at: /docs/config/valve.html"
  "             Note: The pattern used is equivalent to using pattern=\"common\" -->"
  "        <Valve className=\"org.apache.catalina.valves.AccessLogValve\" directory=\"logs\""
  "               prefix=\"localhost_access_log.\" suffix=\".txt\""
  "               pattern=\"%h %l %u %t &quot;%r&quot; %s %b\" />"
  ""
  "      </Host>"
  "    </Engine>"
  "  </Service>"
  "</Server>"])

(defn serverXml1
  "the server-xml, takes a partial-config which will be merged with the default-server-xml-config"
  [config]
  ["<?xml version='1.0' encoding='utf-8'?>"
  "<!--"
  " Licensed to the Apache Software Foundation (ASF) under one or more"
  "  contributor license agreements.  See the NOTICE file distributed with"
  "  this work for additional information regarding copyright ownership."
  "  The ASF licenses this file to You under the Apache License, Version 2.0"
  "  (the \"License\"); you may not use this file except in compliance with"
  "  the License.  You may obtain a copy of the License at"
  ""
  "      http://www.apache.org/licenses/LICENSE-2.0"
  ""
  "  Unless required by applicable law or agreed to in writing, software"
  "  distributed under the License is distributed on an \"AS IS\" BASIS,"
  "  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied."
  "  See the License for the specific language governing permissions and"
  "  limitations under the License."
  "-->"
  "<!-- Note:  A \"Server\" is not itself a \"Container\", so you may not"
  "     define subcomponents such as \"Valves\" at this level."
  "     Documentation at /docs/config/server.html"
  "-->"
  (str "<Server port=\"" (get config :shutdown-port) "\" shutdown=\"SHUTDOWN\">")
  "  <!-- Security listener. Documentation at /docs/config/listeners.html"
  "  <Listener className=\"org.apache.catalina.security.SecurityListener\" />"
  "  -->"
  "  <!--APR library loader. Documentation at /docs/apr.html -->"
  "  <!--"
  "  <Listener className=\"org.apache.catalina.core.AprLifecycleListener\" SSLEngine=\"on\" />"
  "  -->"
  "  <!--Initialize Jasper prior to webapps are loaded. Documentation at /docs/jasper-howto.html -->"
  "  <Listener className=\"org.apache.catalina.core.JasperListener\" />"
  "  <!-- Prevent memory leaks due to use of particular java/javax APIs-->"
  "  <Listener className=\"org.apache.catalina.core.JreMemoryLeakPreventionListener\" />"
  "  <Listener className=\"org.apache.catalina.mbeans.GlobalResourcesLifecycleListener\" />"
  "  <Listener className=\"org.apache.catalina.core.ThreadLocalLeakPreventionListener\" />"
  ""
  "  <!-- Global JNDI resources"
  "       Documentation at /docs/jndi-resources-howto.html"
  "  -->"
  "  <GlobalNamingResources>"
  "    <!-- Editable user database that can also be used by"
  "         UserDatabaseRealm to authenticate users"
  "    -->"
  "    <Resource name=\"UserDatabase\" auth=\"Container\""
  "              type=\"org.apache.catalina.UserDatabase\""
  "              description=\"User database that can be updated and saved\""
  "              factory=\"org.apache.catalina.users.MemoryUserDatabaseFactory\""
  "              pathname=\"conf/tomcat-users.xml\" />"
  "  </GlobalNamingResources>"
  ""
  "  <!-- A \"Service\" is a collection of one or more \"Connectors\" that share"
  "       a single \"Container\" Note:  A \"Service\" is not itself a \"Container\","
  "       so you may not define subcomponents such as \"Valves\" at this level."
  "       Documentation at /docs/config/service.html"
  "   -->"
  (str "  <Service name=\"" (get config :service-name) "\">")
  ""
  "    <!--The connectors can use a shared executor, you can define one or more named thread pools-->"
  "    <!--"
  "    <Executor name=\"tomcatThreadPool\" namePrefix=\"catalina-exec-\""
  (str "        maxThreads=\"" (get config :executorMaxThreads) "\" minSpareThreads=\"4\"/>")
  "    -->"
  ""
  ""
  "    <!-- A \"Connector\" represents an endpoint by which requests are received"
  "         and responses are returned. Documentation at :"
  "         Java HTTP Connector: /docs/config/http.html (blocking & non-blocking)"
  "         Java AJP  Connector: /docs/config/ajp.html"
  "         APR (HTTP/AJP) Connector: /docs/apr.html"
  "         Define a non-SSL HTTP/1.1 Connector on port 8080"
  "    -->"])
  


  

(defn serverXml2
  [config]
[(str "    <Connector port=\"" (get config :http-port) "\" protocol=\"" (get config :protocol) "\"")
  (str "               connectionTimeout=\"" (get config :connectionTimeout) "\"")
  "               URIEncoding=\"UTF-8\""
  "               redirectPort=\"8443\" />"
  "    <!-- A \"Connector\" using the shared thread pool-->"
  "    <!--"
  (str "    <Connector executor=\"" (get config :executor) "\"")
  (str "               port=\"" (get config :http-port) "\" protocol=\"" (get config :protocol) "\"")
  (str "               connectionTimeout=\"" (get config :connectionTimeout) "\"")
  "               redirectPort=\"8443\" />"
  "    -->"
  "    <!-- Define a SSL HTTP/1.1 Connector on port 8443"
  "         This connector uses the JSSE configuration, when using APR, the"
  "         connector should be using the OpenSSL style configuration"
  "         described in the APR documentation -->"
  "    <!--"
  "    <Connector port=\"8443\" protocol=\"HTTP/1.1\" SSLEnabled=\"true\""
  "               maxThreads=\"150\" scheme=\"https\" secure=\"true\""
  "               clientAuth=\"false\" sslProtocol=\"TLS\" />"
  "    -->"
  ""
  "    <!-- Define an AJP 1.3 Connector on port 8009 -->"
  "    <!--"
  "    <Connector port=\"8009\" protocol=\"AJP/1.3\" redirectPort=\"8443\" />"
  "    -->"
  ""
  ""
  "    <!-- An Engine represents the entry point (within Catalina) that processes"
  "         every request.  The Engine implementation for Tomcat stand alone"
  "         analyzes the HTTP headers included with the request, and passes them"
  "         on to the appropriate Host (virtual host)."
  "         Documentation at /docs/config/engine.html -->"
  ""
  "    <!-- You should set jvmRoute to support load-balancing via AJP ie :"
  "    <Engine name=\"Catalina\" defaultHost=\"localhost\" jvmRoute=\"jvm1\">"
  "    -->"
  "    <Engine name=\"Catalina\" defaultHost=\"localhost\">"
  ""
  "      <!--For clustering, please take a look at documentation at:"
  "          /docs/cluster-howto.html  (simple how to)"
  "          /docs/config/cluster.html (reference documentation) -->"
  "      <!--"
  "      <Cluster className=\"org.apache.catalina.ha.tcp.SimpleTcpCluster\"/>"
  "      -->"
  ""
  "      <!-- Use the LockOutRealm to prevent attempts to guess user passwords"
  "           via a brute-force attack -->"
  "      <Realm className=\"org.apache.catalina.realm.LockOutRealm\">"
  "        <!-- This Realm uses the UserDatabase configured in the global JNDI"
  "             resources under the key \"UserDatabase\".  Any edits"
  "             that are performed against this UserDatabase are immediately"
  "             available for use by the Realm.  -->"
  "        <Realm className=\"org.apache.catalina.realm.UserDatabaseRealm\""
  "               resourceName=\"UserDatabase\"/>"
  "      </Realm>"
  ""
  "      <Host name=\"localhost\"  appBase=\"webapps\""
  "            unpackWARs=\"true\" autoDeploy=\"true\">"
  ""
  "        <!-- SingleSignOn valve, share authentication between web applications"
  "             Documentation at: /docs/config/valve.html -->"
  "        <!--"
  "        <Valve className=\"org.apache.catalina.authenticator.SingleSignOn\" />"
  "        -->"
  ""
  "        <!-- Access log processes all example."
  "             Documentation at: /docs/config/valve.html"
  "             Note: The pattern used is equivalent to using pattern=\"common\" -->"
  "        <Valve className=\"org.apache.catalina.valves.AccessLogValve\" directory=\"logs\""
  "               prefix=\"localhost_access_log.\" suffix=\".txt\""
  "               pattern=\"%h %l %u %t &quot;%r&quot; %s %b\" />"
  ""
  "      </Host>"
  "    </Engine>"
  "  </Service>"
  "</Server>"])
 
 
  
(deftest server-xml-config-testing
  "test if the server-xml method with partial-config beeing the old-server
xml-config is still the same"
  (testing
    (is
      (and (= (old-server-xml-string-2) (serverXml2 old-server-xml-config))
           (= (old-server-xml-string-1) (serverXml1 old-server-xml-config))
       ))))
      
  