; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.servertest.fact
  (:require
    [clojure.tools.logging :as logging]
    [pallet.crate :as crate]
    [pallet.actions :as actions]))

(defn format-fact-data
  "Creates the session output."
  ([fact-key script transform-fn]
  {:context "server-test"
   :action-symbol (str "fact: " fact-key)
   :script script
   :out nil
   :raw-out nil
   :transform-fn transform-fn
   :exit nil
   :summary "not executed"})
  ([raw-data transform-fn]
      {:out (if (some? transform-fn) (apply transform-fn (:out raw-data)) (:out raw-data))
       :raw-out (:out raw-data)
       :exit (:exit raw-data)
       :summary (:summary raw-data)})
    )

(defn define-fact
  "Defines a fact based on output of script. 
   Getting fact from target fails if the script execution fails (exitcode <> 0).
   By convention the given script has no side effects on target system."
  {:pallet/plan-fn true}
  [fact-key script & {:keys [transform-fn]}]
  (let [fact-data {fact-key (format-fact-data fact-key script transform-fn)}]
    (actions/as-action
      (logging/info "define fact " fact-key "with" script))
    (crate/assoc-settings :dda-servertest-fact fact-data)
    (actions/with-action-values fact-data)
    ))
  