/*
 * Decompiled with CFR 0.152.
 */
package schema;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class core$fn__12467
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"schema.core")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "A library for data shape definition and validation. A Schema is just Clojure data,\n   which can be used to document and validate Clojure functions and data.\n\n   For example,\n\n   (def FooBar {:foo Keyword :bar [Number]}) ;; a schema\n\n   (check FooBar {:foo :k :bar [1.0 2.0 3.0]})\n   ==> nil\n\n   representing successful validation, but the following all return helpful errors\n   describing how the provided data fails to measure up to schema FooBar's standards.\n\n   (check FooBar {:bar [1.0 2.0 3.0]})\n   ==> {:foo missing-required-key}\n\n   (check FooBar {:foo 1 :bar [1.0 2.0 3.0]})\n   ==> {:foo (not (keyword? 1))}\n\n   (check FooBar {:foo :k :bar [1.0 2.0 3.0] :baz 1})\n   ==> {:baz disallowed-key}\n\n   Schema lets you describe your leaf values using the Any, Keyword, Symbol, Number,\n   String, and Int definitions below, or (in Clojure) you can use arbitrary Java\n   classes or primitive casts to describe simple values.\n\n   From there, you can build up schemas for complex types using Clojure syntax\n   (map literals for maps, set literals for sets, vector literals for sequences,\n   with details described below), plus helpers below that provide optional values,\n   enumerations, arbitrary predicates, and more.\n\n   Assuming you (:require [schema.core :as s :include-macros true]),\n   Schema also provides macros for defining records with schematized elements\n   (s/defrecord), and named or anonymous functions (s/fn and s/defn) with\n   schematized inputs and return values.  In addition to producing better-documented\n   records and functions, these macros allow you to retrieve the schema associated\n   with the defined record or function.  Moreover, functions include optional\n   *validation*, which will throw an error if the inputs or outputs do not\n   match the provided schemas:\n\n   (s/defrecord FooBar\n    [foo :- Int\n     bar :- String])\n\n   (s/defn quux :- Int\n    [foobar :- Foobar\n     mogrifier :- Number]\n    (* mogrifier (+ (:foo foobar) (Long/parseLong (:bar foobar)))))\n\n   (quux (FooBar. 10 \"5\") 2)\n   ==> 30\n\n   (fn-schema quux)\n   ==> (=> Int (record user.FooBar {:foo Int, :bar java.lang.String}) java.lang.Number)\n\n   (s/with-fn-validation (quux (FooBar. 10.2 \"5\") 2))\n   ==> Input to quux does not match schema: [(named {:foo (not (integer? 10.2))} foobar) nil]\n\n   As you can see, the preferred syntax for providing type hints to schema's defrecord,\n   fn, and defn macros is to follow each element, argument, or function name with a\n   :- schema.  Symbols without schemas default to a schema of Any.  In Clojure,\n   class (e.g., clojure.lang.String) and primitive schemas (long, double) are also\n   propagated to tag metadata to ensure you get the type hinting and primitive\n   behavior you ask for.\n\n   If you don't like this style, standard Clojure-style typehints are also supported:\n\n   (fn-schema (s/fn [^String x]))\n   ==> (=> Any java.lang.String)\n\n   You can directly type hint a symbol as a class, primitive, or simple\n   schema.\n\n   See the docstrings of defrecord, fn, and defn for more details about how\n   to use these macros."}));

    public Object invoke() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }
}

