; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.
(ns org.domaindrivenarchitecture.pallet.crate.instantiate-default-liferay
  (:require
      [pallet.api :as api]      
      [pallet.compute :as compute]
      [pallet.compute.node-list :as node-list]
      [org.domaindrivenarchitecture.pallet.crate.user.ssh-key :as ssh-key-record]
      [org.domaindrivenarchitecture.pallet.crate.user.os-user :as os-user-record]
      [org.domaindrivenarchitecture.pallet.crate.config :as config]
      [org.domaindrivenarchitecture.pallet.crate.init :as init]
      [org.domaindrivenarchitecture.pallet.crate.liferay :as liferay]
      [org.domaindrivenarchitecture.pallet.core.cli-helper :as cm-base])
  (:gen-class :main true))
 
(def minimal-config
  (let [db-user-passwd "user1234"
        db-name "lportal"
        db-user-name "liferay_user"
        db-config {:root-passwd "root1234"
                   :db-name db-name
                   :user-name db-user-name
                   :user-passwd db-user-passwd}]
    {:host-name "test" 
     :domain-name "meissa-gmbh.de" 
     :pallet-cm-user-name "root"
     :pallet-cm-user-password "jrtgfjklreoiriridt4rujfj"
     :additional-config 
     {:dda-liferay 
      {:third-party-download-root-dir "https://raw.githubusercontent.com/PolitAktiv/releases/master/liferay/3rd/6.2.1-ce-ga2/"
       :httpd 
       {:vhosts
        {:default
         {:domain-name "test.meissa-gmbh.de"
          :google-id "xxxxxxxxxxxxxxxxxxxxx"
          :cert-letsencrypt {:letsencrypt-mail "admin@meissa-gmbh.de"}}}}
       }}}
    ))

(def config
  {:ssh-keys 
   {:mje-netschnell 
    (ssh-key-record/new-ssh-key
      "ssh-rsa"
      "AAAAB3NzaC1yc2EAAAADAQABAAABAQDd0NIMownb4CSsifH2OBoO3+Hv7I04EjblR5S1VdEOZ2a59nVjWJMIwVj+JkFoon7YaYhgRoqzmDuR7nX8yfHXTljJ2VRwecvbcPV3exaNTcWSMUZMwBKIAEKdTwaZ5wHogJRYeGtPTBYf6k433sGS3TH2zy6YOCwftGKFKc4LkhB7ZnjHTQ4AWefmazt6FV8xi4ohZv/sgy3Tnm9ylxI7vHdVwvwZM4MzOoCIQTHNJWvOMgxuFmSj9vZlwj/IpwmHimxEjBszMf1gzoA7lb/3MShfCB8u3WFpTUiHOlNu1xsbrzC3f0sK9PO1qpQ2QunModw7r3Avx7lE5mK0xPW/"
      "mje@netschnell")
    :mje-jergerProject 
    (ssh-key-record/new-ssh-key
      "ssh-rsa"
      "AAAAB3NzaC1yc2EAAAADAQABAAABAQCeO+eiYDonq3OfxyaUx259y/1OqbhLciD4UlCkguD5PgOuXw+kCXS1Wbdor9cvU8HnsL2j70sPSwCWkcDrrGQ0kpC0GuNO47pKawAOSv07ELpSIIp/nPK5AX2+qI1H3MADBWBE5N1L7sdgatON2A/cC3u5pzcWDaEH7/IJdOkRm8H+qqG+uva6ceFUoYFiJKDixmsmaUXhhDcfYhfpAPBUCSes+HTeT/hk6pdLTX9xXd4H5wyAc+j1e6kPq9ZcxvzZNr9qEMIFjnNL/S9w1ozxQa3sKJQHj8SyVZDlwjvepGS7fKrdlRps938A7I3Y4BaXGX//M1y2HNbUWbMOllLL"
      "mje@jergerProject")
    }
   :os-user
   {:root
    (os-user-record/new-os-user "root" [:mje-netschnell :mje-jergerProject])
    :pallet
    (os-user-record/new-os-user "pallet" "Gz2JnECNpobro" [:mje-netschnell :mje-jergerProject])}
   :node-specific-config
   {:default-instance minimal-config}})

(def provider
  (compute/instantiate-provider
    "node-list"
    :node-list [["liferay" "liferay-group" "185.48.118.79" :ubuntu :id :default-instance]]))

(def liferay-group
  (api/group-spec
    "liferay-group"
    :extends 
    [(config/with-config config)
     init/with-init
     liferay/with-liferay]))

(defn init-node
  [& {:keys [id group-spec]}]
  (cm-base/execute-init-node 
    :id id 
    :group-spec group-spec
    :config config
    :provider provider))

(defn -main
  [group-spec & {:keys [phase]
                 :or {phase '(:settings :configure)}}]
  (cm-base/execute-main 
    group-spec 
    provider 
    :phase phase))