(defproject org.domaindrivenarchitecture/dda-iptables-crate "0.2.0-SNAPSHOT"
  :description "Iptables crate from the DomainDrivenArchitecture pallet project"
  :url "https://www.domaindrivenarchitecture.org"
  :license {:name "Apache License, Version 2.0"
             :url "https://www.apache.org/licenses/LICENSE-2.0.html"}
  :dependencies [[org.clojure/clojure "1.5.1"]
                 [com.palletops/pallet "0.8.0-RC.11"]
                 [ch.qos.logback/logback-classic "1.0.9"]
                 [org.domaindrivenarchitecture/dda-basic-crate "0.1.0-SNAPSHOT"]
                 [org.domaindrivenarchitecture.org/dda-config-crate "0.1.0"]]
  :pallet {:source-paths ["src"]}
  :profiles {:dev
             {:dependencies
              [[com.palletops/pallet "0.8.0-RC.11" :classifier "tests"]
               ]
              :plugins
              [[com.palletops/pallet-lein "0.8.0-alpha.1"]]}
              :leiningen/reply
               {:dependencies [[org.slf4j/jcl-over-slf4j "1.7.2"]]
                :exclusions [commons-logging]}}
  :deploy-repositories [["releases" :clojars]
                        ["snapshots" :clojars]]
  :local-repo-classpath true
  :classifiers {:tests {:source-paths ^:replace ["test"]
                        :resource-paths ^:replace []}})
