; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.iptables
  (:require
    [pallet.actions :as actions]
    [pallet.crate :as crate]
    [clojure.string :as string]
    [org.domaindrivenarchitecture.pallet.crate.iptables.rule-lib :as rule-lib]
    [org.domaindrivenarchitecture.pallet.crate.iptables.iptables-rule :as rule]
    ))

(defn- create-file-content
  ""
  [rules]
  (string/join
    \newline
    rules
    ))

(defn- create-chain
  ""
  [chain rules]
  (concat 
    (rule-lib/prefix chain)
    (into [] (for [[r] rules] (:rule-string r)))
    rule-lib/suffix)
  )


(defn- rules-for-ip-version
  ""
  [ip-version-to-filter & args]
  (let [
        args1 (first args)
        filtered-by-ip-version (filter 
                                 (fn [element] 
                                   (= (:ip-version (first element)) 
                                      ip-version-to-filter)) args1)
        grouped-by-chain (group-by 
                           #(:filter-chain (first %)) filtered-by-ip-version)
        ]
    (flatten (concat (for [[k v] grouped-by-chain] (create-chain k v))))
    ))

(crate/def-aggregate-plan-fn iptables-rule
  ""
  {:arglists '(org.domaindrivenarchitecture.pallet.crate.iptables.IpTablesRule)}
  [ip-tables-rule]
  (fn [& args]
    (let [v4-content (rules-for-ip-version :ipv4 args)
          v6-content (rules-for-ip-version :ipv6 args)]
      (actions/remote-file
        "/etc/iptables/rules.v4"
        :overwrite-changes true
        :content (create-file-content v4-content))
      (actions/remote-file
        "/etc/iptables/rules.v6"
        :overwrite-changes true
        :content (create-file-content v6-content))
   )))