# dda-iptable-crate

A new iptables crate inspired by https://github.com/pallet/iptables-crate.

Compatible with
* pallet version: 0.8
* target os: ubuntu 14.04

Features are
 * uses iptables-persistent
 * provides ipv4 & ipv6 support

## Usage

Usage example from dda-hardening module for ubuntu14/04 :

``` clojure
(defn default-firewall
  ""
  []
  (actions/package "iptables-persistent")
  (iptables/iptables-rule :ipv4 :filter (iptables/allow-lo-rule))
  (iptables/iptables-rule :ipv4 :filter (iptables/antilockout-rule))
  (iptables/iptables-rule :ipv4 :filter (iptables/allow-established-rule :input))
  (iptables/iptables-rule :ipv4 :filter (iptables/v4-drop-ping-rule :input))
  (iptables/iptables-rule :ipv4 :filter (iptables/log-and-drop-rule :input))
  (iptables/iptables-rule :ipv4 :filter (iptables/log-and-drop-rule :foreward))
  
  (iptables/iptables-rule :ipv6 :filter (iptables/allow-lo-rule))
  (iptables/iptables-rule :ipv6 :filter (iptables/antilockout-rule))
  (iptables/iptables-rule :ipv6 :filter (iptables/allow-established-rule :input))
  (iptables/iptables-rule :ipv6 :filter (iptables/v6-drop-ping-rule :input))
  (iptables/iptables-rule :ipv6 :filter (iptables/log-and-drop-rule :input))
  (iptables/iptables-rule :ipv6 :filter (iptables/log-and-drop-rule :foreward))
  (actions/exec
     {:language :bash}
     (stevedore/script
       ("/etc/init.d/iptables-persistent reload"))
     )
)
```

## License

Copyright © 2015 meissa GmbH
Licensed under the Apache License, Version 2.0 (the "License");
