(defproject org.domaindrivenarchitecture/dda-init-crate "0.2.0"
  :description "The dda collected crate"
  :url "https://www.domaindrivenarchitecture.org"
  :pallet {:source-paths ["src"]}
  :license {:name "Apache License, Version 2.0"
            :url "https://www.apache.org/licenses/LICENSE-2.0.html"}
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [prismatic/schema "1.1.3"]
                 [com.palletops/pallet "0.8.12"]
                 [com.palletops/stevedore "0.8.0-beta.7"]
                 [org.domaindrivenarchitecture/dda-pallet-commons "0.2.1"]
                 [org.domaindrivenarchitecture/dda-pallet "0.2.0"]
                 [org.domaindrivenarchitecture/dda-user-crate "0.3.4"]
                 ]
  :profiles {:dev
             {:source-paths ["integration"]
              :dependencies
              [[com.palletops/pallet "0.8.12" :classifier "tests"]
               [org.domaindrivenarchitecture/dda-pallet-commons "0.2.1" :classifier "tests"]
               [org.domaindrivenarchitecture/pallet-aws "0.2.8-SNAPSHOT"]
               [ch.qos.logback/logback-classic "1.1.7"]
               [org.slf4j/jcl-over-slf4j "1.7.21"]]
              :plugins
              [[lein-sub "0.3.0"]]}}
   :local-repo-classpath true
   :repositories [["snapshots" :clojars]
                  ["releases" :clojars]]
   :deploy-repositories [["snapshots" :clojars]
                         ["releases" :clojars]]
   :classifiers {:tests {:source-paths ^:replace ["test" "integration"]
                         :resource-paths ^:replace []}})