; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.init
  (:require
    [clojure.tools.logging :as logging]
    [schema.core :as s]
    [pallet.api :as api]
    [pallet.actions :as actions]
    [pallet.stevedore :as stevedore]
    [pallet.crate :as crate]
    [pallet.crate.ssh-key :as ssh-key]
    [pallet.crate.sudoers :as sudoers]
    [org.domaindrivenarchitecture.pallet.core.dda-crate :as dda-crate]
    [org.domaindrivenarchitecture.pallet.core.dda-crate.config :as internal-config]
    [org.domaindrivenarchitecture.pallet.crate.user.os-user :as os-user]
    [org.domaindrivenarchitecture.pallet.crate.user :as dda-user]
    ))

(defn create-password-user-for-cm
  "Create the user to init the system with password only."
  [user-name user-password]
  (api/make-user user-name :password user-password :no-sudo (= user-name "root"))
  )

(defn init [global-config]
  (let[root-user (os-user/new-os-user-from-config :root global-config)
       pallet-user (os-user/new-os-user-from-config :pallet global-config)]
    (actions/as-action (logging/info "use the init crate."))
    (dda-user/configure-authorized-keys root-user)
    (dda-user/create-sudo-user pallet-user)         
    (actions/directory (str "/home/pallet/state")
                       :action :create
                       :owner "pallet"
                       :group "pallet")))

(defmethod dda-crate/dda-init :dda-init [dda-crate effective-config]
  ;TODO: review jem 2016.05.17: remove illegal access of global config here 
  (let [global-config (internal-config/get-global-config (:facility dda-crate))] 
    (init global-config)))

(def with-init
  (let 
    [init-crate (dda-crate/make-dda-crate
                  :facility :dda-init
                  :version [0 1 0])]
    (dda-crate/create-server-spec init-crate)
    ))
