; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.config.config-provider-test
  (:require
    [clojure.test :refer :all]
    [org.domaindrivenarchitecture.validatable :as validatable]
    [org.domaindrivenarchitecture.valid-mock :as mock]
    [org.domaindrivenarchitecture.pallet.crate.config.config-provider :as sut]
    ))

(deftest construction-not-allowed
  (testing
    "not allowed construction"
  (testing 
    "both parameters are mandantory"
    (is (thrown? AssertionError
                 (sut/new-config-provider 
                   :global nil 
                   :node-specific nil))
        ))
  (testing 
    "unknown parameters are not allowed"
    (is (thrown? AssertionError
                 (sut/new-config-provider 
                   :global {} 
                   :node-specific {}
                   :some-unknown-parameter nil))
        ))
  ))

(deftest validation
  (testing
    "empty validation"
    (is (=
          []
          (validatable/validate 
            (sut/new-config-provider 
              :global {:1 (mock/new-valid-mock true)} 
              :node-specific {:2 (mock/new-valid-mock true)})))
    ))
  )

(deftest construction-allowed
  (testing
    "allowed construction"
    (is (some?
          (sut/new-config-provider 
            :global {:1 (mock/new-valid-mock true)} 
            :node-specific {:2 (mock/new-valid-mock true)})))
    ))