; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.init-pallet
  (:require
    [pallet.api :as api]
    [pallet.actions :as actions]
    [pallet.stevedore :as stevedore]
    [pallet.crate :as crate]
    [pallet.crate.ssh-key :as ssh-key]
    [pallet.crate.sudoers :as sudoers]
    [org.domaindrivenarchitecture.pallet.crate.config :as config]
    [org.domaindrivenarchitecture.pallet.crate.user :as user]
    ))

(defn create-password-user-for-cm
  "Create the user to init the system with password only."
  [user-name user-password]
  (api/make-user user-name :password user-password :no-sudo (= user-name "root"))
  )

(def with-init
  (api/server-spec
    :phases 
    {:init
     (api/plan-fn
       (let [global-config
             (config/get-global-config)]
         
         (user/add-authorized-keys-to-user
           :user-name "root"
           :authorized-key-ids (user/users-authorized-key-ids 
                                 :root global-config)
           :authorized-key-config (user/ssh-key-config global-config))
         
         (user/create-sudo-user
           :user-name "pallet"
           :encrypted-password (user/pallet-user-encrypted-password
                                 :pallet global-config)
           :authorized-key-ids (user/users-authorized-key-ids 
                                 :pallet global-config)
           :authorized-key-config (user/ssh-key-config
                                    global-config))         
         (actions/directory (str "/home/pallet/state")
                     :action :create
                     :owner "pallet"
                     :group "pallet")
       ))
     })
  )
