; Copyright (c) meissa GmbH. All rights reserved.
; You must not remove this notice, or any other, from this software.
;
; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.upgrade
  (:require
    [pallet.api :as api]
    [pallet.actions :as actions]
    ))

(def facility :dda-upgrade)

(defn upgrade-all-packages
  []
  (actions/package-manager :update)
  (actions/exec-script "apt-get upgrade -y"))

(def ^:dynamic with-upgrade
  (api/server-spec
    :phases
    {:init
     (api/plan-fn (upgrade-all-packages))
     :install
     (api/plan-fn (upgrade-all-packages)) 
     :upgrade
     (api/plan-fn (upgrade-all-packages))     
     }
    )
  )