(ns dda.image.ubuntu
  (:require [babashka.tasks :as tasks]))

(defn upgrade-system! []
  (tasks/shell ["apt" "update"])
  (tasks/shell ["apt" "-qqy" "upgrade"]))

(defn cleanup-container! []
  (tasks/shell ["rm" "-f" "/root/.ssh/authorized_keys"])
  (tasks/shell ["rm" "-f" "/root/.ssh/authorized_keys2"])
  (tasks/shell ["apt" "clean"])
  (tasks/shell ["apt" "-qqy" "autoremove" "--purge"])
  (tasks/shell ["apt" "-qqy" "autoclean"])
  (tasks/shell ["rm" "-rf" "/var/lib/apt/lists/"])
  (tasks/shell ["bash" "-c" "rm -rf /tmp/*"])
  (tasks/shell ["bash" "-c" "find /var/cache -type f -exec rm -rf {} \\;"])
  (tasks/shell ["bash" "-c" "find /var/log/ -name '*.log' -exec rm -f {} \\;"]))

(defn cleanupAmi []
  (tasks/shell ["rm" "-f" "/home/ubuntu/.ssh/authorized_keys"])
  (tasks/shell ["rm" "-f" "/home/ubuntu/.ssh/authorized_keys2"])
  (cleanup-container!))
