(ns dda.build.config
  "{:test huhu :long-name #env LOGNAME :gopass-pw #gopass [sopra/test.de] :gopass-field-url #gopass [sopra/test.de url]}"
  (:require [aero.core :as aero]
            [dda.build.infrastructure :as i]))

(defmethod aero/reader 'gopass
  [{:keys [profile] :as opts} tag value]
  (i/execute-output! (into ["gopass" "show" "-y" "-o"] value) {}))

(defn read-config 
  [file]
  (try 
    (aero/read-config file)
    (catch Exception e 
      (do (println (str "Warn: " e))
          {}))
    ))
