(ns dda.build.c4k.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]
            [dda.build.devops.domain :as d]
            [dda.build.terragrunt.domain :as td]))

(s/def ::c4k-app-name string?)
(s/def ::c4k-output string?)
(s/def ::c4k-config-input string?)
(s/def ::c4k-auth-input string?)
(s/def ::grafana-cloud-url string?)

(s/def ::config
  (s/merge ::d/devops
           (s/keys :req-un [::c4k-output ::c4k-config-input ::c4k-auth-input ::c4k-app-name]
                   :opt-un [::grafana-cloud-url ::grafana-cloud-user ::grafana-cloud-password])))

(defn-spec config-path string?
  [config ::config]
  (let [{:keys [c4k-config-input]} config]
    (str (d/build-path config) "/" c4k-config-input)))

(defn-spec auth-path string?
  [config ::config]
  (let [{:keys [c4k-auth-input]} config]
    (str (d/build-path config) "/" c4k-auth-input)))

(defn-spec output-path string?
  [config ::config]
  (let [{:keys [c4k-output]} config]
    (str (d/build-path config) "/" c4k-output)))

(defn-spec clean-build-dir-command seq?
  [config ::config]
  ["rm"  "-rf" (d/build-path (dissoc config :module))])

(defn-spec c4k-uberjar-command seq?
  [config ::config]
  (let [{:keys [c4k-app-name]} config
        executable-name (str "c4k-" c4k-app-name "-standalone.jar")]
    [["bash" "-c" (str executable-name " " (config-path config) " " (auth-path config) " > " (output-path config))]]))

(defn-spec c4k-graalvm-command seq?
  [config ::config]
  (let [{:keys [c4k-app-name]} config
        executable-name (str "c4k-" c4k-app-name)]
    [["bash" "-c" (str executable-name " " (config-path config) " " (auth-path config) " > " (output-path config))]]))

(defn-spec create-c4k-config map?
  [module-config map?
   config ::config
   tf-out ::td/tf-out]
  (let [{:keys [name module stage]} config]
    (merge
     {:fqdn (:fqdn (:value (:out tf-out)))}
     (when (contains? config :grafana-cloud-url)
           {:mon-cfg {:grafana-cloud-url (:grafana-cloud-url config)
                      :cluster-name (str name "-" module)
                      :cluster-stage stage}})
     module-config)))
