(ns dda.build.devops
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.test.alpha :as st]
   [clojure.spec.alpha :as s]
   [dda.build.devops.domain :as domain]
   [dda.build.infrastructure :as i]))

(s/def ::name ::domain/name)
(s/def ::module ::domain/module)
(s/def ::stage ::domain/stage)
(s/def ::project-root-path ::domain/project-root-path)
(s/def ::build-dir-name ::domain/build-dir-name)

(s/def ::devops
  (s/keys :req-un [::name]
          :opt-un [::module ::stage ::project-root-path ::build-dir-name ::debug ::dry-run]))

(def default {:name "dda-backup"
              :project-root-path "."
              :build-dir-name "target"
              :stage "dev"
              :debug false
              :dry-run false})

(defn-spec env-or-file string?
  [name string?]
  (let [from-env (System/getenv name)
        name-from-file (System/getenv (str name "_FILE"))]
    (cond
      (some? from-env) from-env
      (some? name-from-file) (slurp name-from-file)
      :else (throw (RuntimeException.
                    (str "Environment: [" name "," name-from-file "] was missing."))))))

(defn-spec clean-build-dir! nil?
  [devops ::devops]
  (let [final (merge default devops)]
    (i/execute! (domain/clean-build-dir-command final) final)))

(defn-spec create-build-dir! nil?
  [devops ::devops]
  (let [final (merge default devops)]
    (i/execute! (domain/create-build-dir-command final) final)))

(st/instrument `clean-build-dir!)
(st/instrument `create-build-dir!)
(st/instrument `env-or-file)#
