(ns dda.build.provs.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]
            [dda.build.devops.domain :as d]
            [dda.c4k-common.predicate :as pred]
            [dda.build.c4k.domain :as c4k-d]
            [dda.build.terragrunt.domain :as td]))

; TODO: Use a better spec for emails
;       should be added to c4k-common, it seems common enough
(s/def ::email pred/bash-env-string?)
(s/def ::fqdn pred/fqdn-string?)
(s/def ::ipv4 pred/ipv4-string?)
(s/def ::ipv6 pred/ipv6-string?)
(s/def ::echo boolean?)
(s/def ::k3s-output-filename string?)
(s/def ::k3s-provision-user pred/bash-env-string?)
(s/def ::config
  (s/keys :req-un [::d/name ::d/stage ::d/project-root-path ::d/build-dir-name ::d/debug
                   ::d/dry-run ::c4k-d/c4k-output-filename 
                   ::email ::echo ::k3s-output-filename ::k3s-provision-user]
          :opt-un [::d/module]))
(s/def ::node
  (s/keys :req-un [::ipv4 ::ipv6]))
(s/def ::letsencryptEndpoint pred/letsencrypt-issuer?)
(s/def ::certmanager
  (s/keys :req-un [::email ::letsencryptEndpoint]))
(s/def ::server-config
  (s/keys :req-un [::fqdn ::node ::certmanager ::echo]))

(defn-spec output-path string?
  [config ::config]
  (let [{:keys [k3s-output-filename]} config]
    (str (d/build-path config) "/" k3s-output-filename)))

(defn-spec provs-server-command seq?
  [config ::config
   tf-out ::td/tf-out]
  (let [{:keys [k3s-output-filename k3s-provision-user]} config
         fqdn (get-in tf-out [:out :value :fqdn])]
    [["provs-server.jar" "k3s" (str k3s-provision-user "@" fqdn) "-c" (output-path config) "-a" (c4k-d/output-path config)]]))

(defn-spec create-k3s-config map?
  [config ::config
   tf-out ::td/tf-out]
  (let [{:keys [stage email echo]} config
        letsencrypt-endpoint (if (= stage "prod") "prod" "staging")
        values (:value (:out tf-out))
        {:keys [fqdn ipv4 ipv6]} values]
    {:fqdn fqdn
     :node {:ipv4 ipv4
            :ipv6 ipv6}
     :certmanager {:email email
                   :letsencryptEndpoint letsencrypt-endpoint}
     :echo echo}))
