(ns dda.build.image
  (:require [orchestra.core :refer [defn-spec]]
            [babashka.tasks :as t]
            [dda.build.devops :as d]
            [dda.build.image.domain :as domain]))

(def default
  (merge d/default {}))

(defn-spec container-build! nil?
  [devops ::d/devops]
  (let [final (merge default devops)]
    (d/create-build-dir! final)
    (d/create-build-dir! final)
    (apply t/shell (domain/copy-image-command final))
    (apply t/shell (domain/dbuild-command final))))
