(ns dda.build.gopass.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]))

(s/def ::path string?)
(s/def ::field string?)
(s/def ::gopass-entry (s/keys :req-un [::path]
                              :opt-un [::field]))
(s/def ::config (s/map-of keyword? ::gopass-entry))

(s/def ::resolved-config (s/map-of keyword? string?))

(s/def ::gopass-command (s/coll-of string?))
(s/def ::gopass-commands (s/coll-of ::gopass-command))

(defn-spec gopass-show-command ::gopass-command
  [entry ::gopass-entry]
  (let [{:keys [path field] :or {field nil}} entry]
    (if (nil? field)
      ["gopass" "show" "-y" "-o" path]
      ["gopass" "show" "-y" "-o" path field])))
