(ns dda.build.c4k.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]
            [dda.build.devops.domain :as d]
            [dda.build.terragrunt.domain :as td]))

(s/def ::c4k-output-filename string?)

(s/def ::c4k-config-filename string?)
(s/def ::c4k-auth-filename string?)

(s/def ::config
  (s/keys :req-un [::d/name ::d/stage ::d/project-root-path ::d/build-dir-name ::d/debug
                   ::d/dry-run ::c4k-output-filename ::c4k-config-filename ::c4k-auth-filename]
          :opt-un [::d/module]))

(defn-spec config-path string?
  [config ::config]
  (let [{:keys [c4k-config-filename]} config]
    (str (d/build-path config) "/" c4k-config-filename)))

(defn-spec auth-path string?
  [config ::config]
  (let [{:keys [c4k-auth-filename]} config]
    (str (d/build-path config) "/" c4k-auth-filename)))

(defn-spec output-path string?
  [config ::config]
  (let [{:keys [c4k-output-filename]} config]
    (str (d/build-path config) "/" c4k-output-filename)))

(defn-spec clean-build-dir-command seq?
  [config ::config]
  ["rm"  "-rf" (d/build-path (dissoc config :module))])

(defn-spec c4k-uberjar-command seq?
  [config ::config]
  (let [{:keys [name]} config
        executable-name (str "c4k-" name "-standalone.jar")]
    ["bash" "-c" (str executable-name " " (config-path config) " " (auth-path config) " > " (output-path config))]))

(defn-spec c4k-graalvm-command seq?
  [config ::config]
  (let [{:keys [name]} config
        executable-name (str "c4k-" name)]
    ["bash" "-c" (str executable-name " " (config-path config) " " (auth-path config) " > " (output-path config))]))

(defn-spec create-c4k-config map?
  [config ::config
   tf-out ::td/tf-out]
  (let [{:keys [stage]} config
         issuer (if (= stage "prod") "prod" "staging")
         fqdn (:fqdn (:value (:out tf-out)))]
    {:issuer issuer :fqdn fqdn}))
