(ns dda.build.provs
  (:require [orchestra.core :refer [defn-spec]]
            [clojure.spec.test.alpha :as st]
            [cheshire.core :refer [generate-string]]
            [dda.build.devops :as d]
            [dda.build.provs.domain :as domain]
            [dda.build.infrastructure :as i]))

(def default
  (merge d/default {:k3s-output-filename "out_k3sServerConfig.yaml"
                    :k3s-provision-user "root"
                    :c4k-output-filename "c4k-app.yaml"
                    :email "default@email.rep"
                    :echo false}))

(defn-spec run-provs-server! nil?
  [devops ::d/devops]
  (let [config (merge default devops)]
    (doseq [c (domain/provs-server-command config)]
      (i/execute! c config))))

(defn-spec write-k3s-config! nil?
  "Create a server config for provs using tf-out and write it to a file
   
   Requires ':email' to be set, otherwise certs will not work
   Default: out_k3sServerConfig.yaml
   can be changed by adding another value for ':k3s-output-filename'
   "
  [devops ::d/devops
   tf-out ::domain/tf-out]
  (let [config (merge default devops)
        tf-out-k3s-config (domain/create-k3s-config config tf-out)]
    (->> tf-out-k3s-config
         (generate-string)
         (spit (domain/output-path config)))))

(st/instrument `run-provs-server!)
(st/instrument `write-k3s-config!)