# dda-basic-crate

This pallet crate can be used to lift versioned crates and apply actions depending on the 
node version of the crate.

Artefacts can be found at
* https://clojars.org/org.domaindrivenarchitecture/dda-basic-crate

## Versions

A version is specified by a vector of numbers of arbitrary length. The first number is the
most significant one. Example: [1 5 2] represents version 1.5.2

If one version is longer than the other the shorter one is filled with zeros when compared
to the longer:

```
  [1 2] = [1 2 0]
  [1 2] < [1 2 1]
```

Version correspond to strings:

```
  [1 5 2]  corresponds to  "1.5.2"
```

this conversion is made by ver_fromstr and ver_str. When converting a string to version the string is split at the dots, then digits are read until a non-digit character occurs.

```
   (ver_fromstr "1.5a") evaluates to [1 5]
   (ver_fromstr "aaj3u.1a2..") evaluates to [3.1]
```
   
## Statefile

A versioned crate manages its remote state in a state file. This is created in /home/pallet/state/.
The content of the state file is the version (represented as string) of the crate that is deployed 
to the machine.

## Usage

### Versioned Crate

Use ->VersionedCrate to create a versioned crate:

```
(def crate-test (->VersionedCrate 
   :testapp [1 5 1]
   configure-test install-test)) 
```

Here configure-test and install-test are each either
  * satisfying VersionedPlan (see below).
  * a simple function returning a pallet plan and taking two argument (app-name and config).
  
A install or configure plan can be created by
```
(create-install-plan crate-test)
(create-configure-plan crate-test)
```

A complete pallet server-spec can be created by
```
(def with-test (create-server-spec crate-test))
```

### VersionedPlan

A versioned plan is a version-aware plan, that plans actions according to the remote version
of the crate. To create a versioned plan use the defversionedplan macro:

```
(defversionedplan installplan-test 
  condition   actions-fn   [optional: actions-instance-fn]
  [...])
```
Any number of pairs of condition and actions can be specified.

An actions-fn is a function taking one argument, this function is called and the node configuration is passed. An actions-instance-fn is a function taking two arguments, this is called for each instance specified in the node configuration and the instance name and the instance configuration is passed.

Conditions: To create conditions use versions.clj:
```
 (ver-lesseq? [1 2 3])  ; matches if remote version is smaller or equal to 1.2.3
 (ver-notinstalled?)    ; matches if no remote version is installed
 (ver-always?)          ; matches always
```


### Complete Example

```
(ns org.domaindrivenarchitecture.pallet.crate.testcrate2
  (:require
    [clojure.tools.logging :as logging]
    [pallet.actions :as actions]
    [org.domaindrivenarchitecture.pallet.crate.versions :refer :all]
    [org.domaindrivenarchitecture.pallet.crate.basecrate :refer :all]
))

(defn debugaction
  [str]
  (fn [& args] 
    (actions/as-action (logging/warn "debugaction" str args))))

(defversionedplan installpath-test 
  (ver-notinstalled?)   (debugaction "install: not installed yet")
  (ver-lesseq? [1 2 3]) (debugaction "install: from <= 1 2 3")
  (ver-lesseq? [1 0 0]) (debugaction "install: from <= 1 0 0")
  (ver-always?)         (debugaction "install: always") (debugaction "install instance: always"))

(def crate-test (->VersionedCrate 
  :testapp [1 5 1] 
  (debugaction "configure") 
  installpath-test)) 

(def with-test (create-server-spec crate-test))
```


### Instances

Instances are specified in the configuration key :instances. For each key in this map entry an instance
installation and/or configuration can be planed. A instance installation or configuration function takes four
arguments: app-name, config, instance-key and instance-config. It can be defined by the defversionedplan macro as well
by specifying this function after the app installation/configuration function.

For Example:

```
(defn debugaction
  [str]
  (fn [& args] 
    (actions/as-action (logging/warn "debugaction" str args))))

(defversionedplan installpath-test 
  (ver-notinstalled?)   (debugaction "installing app") (debugaction "installing instance")
```



## License

Copyright © 2015 meissa GmbH
Licensed under the Apache License, Version 2.0 (the "License");