; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.testcrate.test
  (:require
    [clojure.tools.logging :as logging]
    [pallet.actions :as actions]
    [org.domaindrivenarchitecture.pallet.crate.versions :refer :all]
    [org.domaindrivenarchitecture.pallet.crate.basecrate :refer :all]
))

(defn debugaction
  [str]
  (fn [& args] 
    (actions/as-action (logging/warn "debugaction" str args))))

(defversionedplan installplan-test 
  (ver-notinstalled?)   (debugaction "install: not installed yet")
  (ver-lesseq? [1 2 3]) (debugaction "install: from <= 1 2 3")
  (ver-lesseq? [1 0 0]) (debugaction "install: from <= 1 0 0")
  (ver-always?)         (debugaction "install: always >app<") (debugaction "install: always >instance<"))

(def crate-test (->VersionedCrate 
  :testapp [1 5 1] 
  installplan-test nil)) 

(def with-test (create-server-spec crate-test))

