; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns org.domaindrivenarchitecture.pallet.crate.dda-base
  (:require
      [pallet.actions :as actions]
      [pallet.crate :as crate]
      [pallet.stevedore :as stevedore]
      ))

;;;;;;;;;;;;;;;;;;;;
;                  ;
;    DEPRECATED    ;
;                  ;
;;;;;;;;;;;;;;;;;;;;

(defrecord Configurable [app-name config 
                         config-function instance-config-function])

(defrecord Installable [app-name config  
                        install-function instance-install-function])

(defn configurable [app-name config 
                    config-function instance-config-function]
  (map->Configurable {:app-name app-name 
                      :config config
                      :config-function config-function
                      :instance-config-function instance-config-function}))

(defn configure-with-instances-wc [component]
  (let [{:keys [app-name config config-function instance-config-function]} component]
    (apply config-function [app-name config])
    (doseq [[instance-key instance-config] (:instances config)]
      (apply instance-config-function [app-name config instance-key instance-config])))) 

(crate/defplan configure-with-instances
  ""
  [app-name config config-function 
   & {:keys [instance-config-function]}]
  (let [component (configurable app-name config config-function instance-config-function)]
    (configure-with-instances-wc component)))

(crate/defplan install-with-instances
  [app-name config install-function 
   & {:keys [instance-install-function]}]
  (let [installed-marker-path
        (str "/home/pallet/state/" app-name)]
    (actions/plan-when-not 
      (stevedore/script (file-exists? ~installed-marker-path))
      (apply install-function [app-name config])
      (actions/file
        installed-marker-path
        :action :create)
      ))
  (doseq [[instance-key instance-config] (:instances config)]
    (let [installed-marker-path
          (str "/home/pallet/state/" app-name "-" (name instance-key))]
      (actions/plan-when-not 
        (stevedore/script (file-exists? ~installed-marker-path))
        (apply instance-install-function [app-name config instance-key instance-config])
        (actions/file
          installed-marker-path
          :action :create)
        ))
    ))