; Licensed to the Apache Software Foundation (ASF) under one
; or more contributor license agreements. See the NOTICE file
; distributed with this work for additional information
; regarding copyright ownership. The ASF licenses this file
; to you under the Apache License, Version 2.0 (the
; "License"); you may not use this file except in compliance
; with the License. You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.


(ns org.domaindrivenarchitecture.pallet.test-utils)

(defn find-expected [expected values]
  (filter #(.contains (str %) expected) (seq values)))

(defn extract-node-values [plan]
  (let [files-to-transfer (nth plan 0)
        session (nth plan 1)
        node-values (-> session :plan-state :node-values)]
    node-values))

(defn extract-nth-action-command [plan action-number]
  (let [node-values (extract-node-values plan)
        action ((nth (keys node-values) action-number) node-values)
        command (nth action 1)]
    command))