# dda-basic-crate

This pallet crate can be used to lift versioned crates and apply actions depending on the 
node version of the crate.

Artefacts can be found at
* https://clojars.org/org.domaindrivenarchitecture/dda-basic-crate

## Usage

Usage of a versioned crate:

```
(defn debugaction
  [str]
  (fn [app-name version config] 
    (actions/as-action (logging/warn "debugaction" str "(" app-name version ")"))))

; In this intall-function set an arbitrary number of {:selector, :install-fn} pairs can be
; specified. When installed the selector will be evaluated to decide if the install-fn actions
; are executed for each node.
;
; A selector is a function taking two arguments [palletversion remoteversion],
; predefined selectors are:
;  * selector_clean_install (execute if no version installed yet)
;  * selector_from_lesseq   (execute if smaller version than specified and already installed and not same version)
;  * selector_always        (execute always)
;
(def install-fn-set 
  #{
    ; clean install
    {:selector (dda-version/selector_clean_install)
     :install-fn [(debugaction "clean install") ]}
    ; from <= 1.2
    {:selector (dda-version/selector_from_lesseq [1 2])
     :install-fn [(debugaction "from <= 1.2")]}
    ; always
    {:selector (dda-version/selector_always)
     :install-fn [(debugaction "always") (debugaction "always")]}
    }
  )

; simple server-spec using a versioned crate
(def with-test
  (api/server-spec
    :phases 
    {:install
     (api/plan-fn (dda-version/install-with-versions "test" [1 3] install-fn-set nil))
    }))
```

## License

Copyright © 2015 meissa GmbH
Licensed under the Apache License, Version 2.0 (the "License");