(ns dda.backup.monitoring.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [clojure.string :as st]))

(s/def ::url string?)
(s/def ::name string?)
(s/def ::namespace string?)
(s/def ::metrics map?)
(s/def ::additional-tags map?)

(s/def ::config (s/keys :req-un [::url ::name ::metrics ::namespace]
                        :opt-un [::additional-tags]))

(defn-spec labels string?
  [config ::config]
  (let [{:keys [namespace additional-tags]} config]
    (st/join ","
     (into [(str "namespace=\"" namespace "\"")
            (str "name=\"" (get config :name) "\"")]
           (map (fn [entry]
                  (str (name (key entry)) "=\"" (val entry) "\""))
                additional-tags))
     )))

(defn-spec collect-metrics string?
  [config ::config]
  (let [{:keys [metrics]} config]
    (str
     (->> metrics
          (map (fn [entry] (str (name (key entry))
                                "{" (labels config) "}" 
                                " " (val entry))))
          (st/join "\n"))
     "\n")))