(ns dda.backup.restore
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.restore.domain :as domain]
   [dda.backup.restic :as restic]
   [dda.backup.postgresql :as pg]
   [dda.backup.infrastructure :as i]))

(def default (merge restic/default 
                    pg/default
                    {:snapshot-id "latest"}))

(s/def ::restore-file-config
  (s/merge ::restic/restic-config
           (s/keys :req-un [::domain/restore-target-directory]
                   :opt-un [::domain/snapshot-id])))

(s/def ::restore-db-config
  (s/merge ::pg/pg-config
           (s/keys :req-un [::domain/snapshot-id])))

(defn-spec restore-file! nil?
  [config ::restore-file-config]
  (let [config-w-defaults (merge default config)]
    (restic/unlock! config-w-defaults)
    (i/execute!
     (domain/restore-dir-command config-w-defaults)
     config-w-defaults)))

(defn-spec restore-db! nil?
  [config ::restore-db-config]
  (let [config-w-defaults (merge default config)]
    (restic/unlock! config-w-defaults)
    (i/execute! (domain/restore-db-command config-w-defaults) config-w-defaults)))


;; function restore-roles() {
;;   local snapshot_id="${1:-latest}"; shift

;;   if [ -z ${CERTIFICATE_FILE} ];
;;   then
;;     roles-unlock-command
;;     restic -r ${RESTIC_REPOSITORY}/${backup_pg_role_path} dump ${snapshot_id} stdin | \
;;       psql -d template1 -h ${POSTGRES_SERVICE} -p ${POSTGRES_PORT} -U ${POSTGRES_USER} \
;;       --no-password
;;   else
;;     roles-unlock-command --cacert ${CERTIFICATE_FILE}
;;     restic -r ${RESTIC_REPOSITORY}/${backup_pg_role_path} dump ${snapshot_id} stdin  --cacert ${CERTIFICATE_FILE} | \
;;       psql -d template1 -h ${POSTGRES_SERVICE} -p ${POSTGRES_PORT} -U ${POSTGRES_USER} \
;;       --no-password
;;   fi
;; }
