(ns dda.backup.management.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core.domain :as cd]))

(s/def ::config
  (s/keys :req-un [::cd/restic-repository ::cd/backup-path ::cd/days-to-keep ::cd/months-to-keep]
          :opt-un [::cd/certificate-file ::cd/password-file]))

(defn-spec check-repo-command ::cd/commands
  [config ::config]
  (cd/repo-command config ["check"]))

(defn-spec init-repo-command ::cd/commands
  [config ::config]
  (cd/repo-command config ["init"]))

(defn-spec unlock-repo-command ::cd/commands
  [config ::config]
  (cd/repo-command config ["--cleanup-cache" "unlock"]))

(defn-spec list-snapshot-command ::cd/commands
  [config ::config]
  (cd/repo-command config ["snapshots"]))

(defn-spec forget-command ::cd/commands
  [config ::config]
  (let [{:keys [days-to-keep months-to-keep]} config]
    (cd/repo-command config ["forget" "--group-by" ""
                             "--keep-last" "1"
                             "--keep-daily" (str days-to-keep)
                             "--keep-monthly" (str months-to-keep) "--prune"])))
