(ns dda.backup.backup.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core.domain :as cd]))

(s/def ::files (s/+ string?))

(s/def ::config
  (s/keys :req-un [::files
                   ::cd/restic-repository ::cd/backup-path]
          :opt-un [::cd/certificate-file ::cd/password-file ::cd/directory]))

(defn-spec backup-files-command ::cd/commands
  [config ::config]
  (let [{:keys [files]} config]
    (cd/repo-command config (into ["backup"] files))))
