(ns dda.backup.core.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]))

(s/def ::command (s/cat
                  :app string?
                  :params (s/* string?)))
(s/def ::commands (s/coll-of ::command))

(s/def ::certificate-file string?)
(s/def ::password-file string?)
(s/def ::restic-repository string?)
(s/def ::backup-path string?)
(s/def ::directory string?)
(s/def ::days-to-keep pos?)
(s/def ::months-to-keep pos?)

(s/def ::config
  (s/keys :req-un [::restic-repository ::backup-path ::days-to-keep ::months-to-keep]
          :opt-un [::certificate-file ::password-file ::directory]))

(defn-spec repo-command ::commands
  [config ::config
   command ::command]
  (let [{:keys [certificate-file password-file directory restic-repository backup-path]} config]
    [(into
      []      
      (concat
       (if (some? directory)
         [{:dir directory}]
         [])
       ["restic" "-r" (str restic-repository "/" backup-path) "-v"]
       (cond
         (some? certificate-file)
         ["--cacert" certificate-file]
         (some? password-file)
         ["--password-file" password-file]
         :else
         [])
       command))]))
