(ns dda.backup.backup
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core.domain :as cd]
   [dda.backup.backup.domain :as domain]
   [dda.backup.core :as core]
   [dda.backup.management :as mgm]
   [dda.backup.infrastructure :as i]))

(s/def ::config
  (s/keys :req-un [::cd/restic-repository ::cd/backup-path]
          :opt-un [::cd/certificate-file ::cd/directory ::cd/debug ::cd/dry-run]))

(defn-spec backup! nil?
  [config ::config
   files (s/* string?)]
  (let [config-w-defaults (merge core/default config)]
    (mgm/unlock! config-w-defaults)
    (i/execute! 
     (domain/backup-files-command config-w-defaults files) 
     config-w-defaults)
    (mgm/forget! config-w-defaults)
    ))