(ns dda.backup.management.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core.domain :as core]))

(defn-spec check-repo-command ::core/commands
  [config ::core/config]
  (core/repo-command config ["check"]))

(defn-spec init-repo-command ::core/commands
  [config ::core/config]
  (core/repo-command config ["init"]))

(defn-spec unlock-repo-command ::core/commands
  [config ::core/config]
  (core/repo-command config ["--cleanup-cache" "unlock"]))

(defn-spec list-snapshot-command ::core/commands
  [config ::core/config]
  (core/repo-command config ["snapshots"]))

(defn-spec forget-command ::core/commands
  [config ::core/config]
  (let [{:keys [days-to-keep months-to-keep]} config]
    (core/repo-command config ["forget" "--group-by" "''" 
                               "--keep-last" "1"
                               "--keep-daily" (str days-to-keep) 
                               "--keep-monthly" (str months-to-keep) "--prune"])))
