(ns dda.backup.backup
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core.domain :as core]
   [dda.backup.backup.domain :as domain]
   [dda.backup.management :as mgm]
   [dda.backup.infrastructure :as i]))

(s/def ::config
  (s/keys :req-un [::core/restic-repository ::core/backup-path]
          :opt-un [::core/certificate-file ::core/directory ::core/debug ::core/dry-run]))

(defn-spec backup! nil?
  [config ::config
   files (s/* string?)]
  (let [config-w-defaults (merge core/default config)]
    (mgm/unlock! config-w-defaults)
    (i/execute! 
     (domain/backup-files-command config-w-defaults files) 
     config-w-defaults)
    (mgm/forget! config-w-defaults)
    ))