(ns dda.backup.infrastructure
  (:require [orchestra.core :refer [defn-spec]]
            [babashka.tasks :as t]
            [dda.backup.core :as core]))

(defn-spec execute! nil?
  [commands ::core/command
   config any?]
  (let [{:keys [dry-run debug]} config]
    (doseq [c commands]
      (when debug
        (println c))
      (when-not dry-run
        (apply t/shell c)))))
