(ns dda.backup.management.domain
  (:require
   [orchestra.core :refer [defn-spec]]
   [clojure.spec.alpha :as s]
   [dda.backup.core :as core]))

(s/def ::certificate-file string?)
(s/def ::restic-repository string?)
(s/def ::backup-path string?)

(s/def ::config
  (s/keys :req-un [::restic-repository ::backup-path]
          :opt-un [::certificate-file]))

(defn-spec init-repo-command ::core/commands
  [config ::config]
  (let [{:keys [certificate-file restic-repository backup-path]} config]
    (if (some? certificate-file)
      [ ["restic" "-r" (str restic-repository "/" backup-path) "-v" "init" "--cacert" certificate-file]]
      [ ["restic" "-r" (str restic-repository "/" backup-path) "-v" "init"]]
      )))

(defn-spec list-snapshot-command ::core/commands
  [config ::config]
  (let [{:keys [certificate-file restic-repository backup-path]} config]
    (if (some? certificate-file)
      [["restic" "-r" (str restic-repository "/" backup-path) "-v" "snapshots" "--cacert" certificate-file]]
      [["restic" "-r" (str restic-repository "/" backup-path) "-v" "snapshots"]])))
