(ns dda.clj-threats.domain.report
  (:require
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.common :as cm]
   [dda.clj-threats.domain.attack-tree :as ak]
   [dda.clj-threats.domain.threagile :as ta]
   [dda.clj-threats.domain.rules :as ru]
   [dda.clj-threats.domain.report.model :as mod]
   [dda.clj-threats.domain.report.management-summary :as mgs]
   [dda.clj-threats.domain.report.trust-boundary :as tbo]
   [dda.clj-threats.domain.report.threats :as trt]))

(s/def ::document ::mod/document)

(defn-spec title-page ::document
  [threagile ::ta/threagile
   attacks ::ak/attacks
   threats-with-mitigation ::ru/threats
   threats-without-mitigation ::ru/threats]
  (let [childs [(mgs/management-summary threagile attacks threats-with-mitigation threats-without-mitigation)
                (tbo/trust-boundaries threagile)
                (trt/threats threagile attacks threats-with-mitigation)]]
    {:path "report.adoc"
     :dir ""
     :lines
     (cm/concat-vec
      ["include::_config.adoc[]"
       (str "= " (get-in threagile [:title]))
       ""
       (str ":author: " (get-in threagile [:author :name]))
       ""
       ":toc:"
       ""]
      (map mod/include-child childs))   
     :childs childs}))

(defn-spec report ::document
  [threagile ::ta/threagile
   attacks ::ak/attacks
   threats-with-mitigation ::ru/threats
   threats-without-mitigation ::ru/threats]
  (title-page threagile attacks 
              threats-with-mitigation threats-without-mitigation))