(defproject org.domaindrivenarchitecture/clj-threats "1.5.0"
  :description "clojure threagile implementation with additional attack tree modelling"
  :url "https://domaindrivenarchitecture.org"
  :license {:name "Apache License, Version 2.0"
            :url "https://www.apache.org/licenses/LICENSE-2.0.html"}
  :dependencies [[org.clojure/clojure "1.12.4" :scope "provided"]
                 [org.clojure/tools.reader "1.6.0"]
                 [org.domaindrivenarchitecture/c4k-common-clj "12.0.1"]]
  :target-path "target/%s/"
  :source-paths ["src/main/clj"
                 "src/main/cljc"]
  :resource-paths ["src/main/resources"
                   "project.clj"]
  :repositories [["snapshots" :clojars]
                 ["releases" :clojars]]
  :deploy-repositories [["snapshots" {:sign-releases false :url "https://clojars.org/repo"}]
                        ["releases" {:sign-releases false :url "https://clojars.org/repo"}]]
  :profiles {:test {:test-paths ["src/test/clj"
                                 "src/test/cljc"]
                    :resource-paths ["src/test/resources"]
                    :dependencies [[dda/data-test "0.1.1"]]}
             :dev {:plugins [[lein-shell "0.5.0"]]}}
  :release-tasks [["test"]
                  ["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["change" "version" "leiningen.release/bump-version"]])
