(ns dda.clj-threats.domain.threagile.technical-asset
  (:require
   [clojure.spec.alpha :as s]
   [orchestra.core :refer [defn-spec]]
   [dda.c4k-common.predicate :as cp]
   [dda.clj-threats.domain.threagile.communication-link :as cl]))

(s/def ::name keyword?)
(s/def ::id string?)
(s/def ::description string?)
(s/def ::out_of_scope boolean?)

(s/def ::technical-asset (s/keys :req-un [::id ::description ::cl/communication_links]
                            :opt-un [::out_of_scope]))

(s/def ::technical_assets (s/map-of ::name ::technical-asset))
